//
//  Colors.swift
//  Do It
//
//  Created by Jim Dovey on 4/13/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

extension Color {
    #if os(iOS) || os(tvOS)
    
    // primary and secondary map to label and secondaryLabel
    static var tertiaryLabel = Color(.tertiaryLabel)
    static var quaternaryLabel = Color(.quaternaryLabel)
    
    static var link = Color(.link)
    
    static var placeholderText = Color(.placeholderText)
    
    static var separator = Color(.separator)
    static var opaqueSeparator = Color(.opaqueSeparator)
    
    static var primaryBackground = Color(.systemBackground)
    static var secondaryBackground = Color(.secondarySystemBackground)
    static var tertiaryBackground = Color(.tertiarySystemBackground)
    
    static var primaryGroupedBackground = Color(.systemGroupedBackground)
    static var secondaryGroupedBackground = Color(.secondarySystemGroupedBackground)
    static var tertiaryGroupedBackground = Color(.tertiarySystemGroupedBackground)
    
    static var primaryFill = Color(.systemFill)
    static var secondaryFill = Color(.secondarySystemFill)
    static var tertiaryFill = Color(.tertiarySystemFill)
    static var quaternaryFill = Color(.quaternarySystemFill)
    
    #elseif os(macOS)
    
    // primary and secondary map to labelColor and secondaryLabelColor
    static var tertiaryLabel = Color(.tertiaryLabelColor)
    static var quaternaryLabel = Color(.quaternaryLabelColor)
    
    static var link = Color(.linkColor)
    
    static var placeholderText = Color(.placeholderTextColor)
    
    static var separator = Color(.separatorColor)
    static var opaqueSeparator = Color(.separatorColor)
    
    static var primaryBackground = Color(.windowBackgroundColor)
    static var secondaryBackground = Color(.controlBackgroundColor)
    static var tertiaryBackground = Color(.textBackgroundColor)
    
    static var primaryGroupedBackground = Color(.underPageBackgroundColor)
    static var secondaryGroupedBackground = Color(.controlBackgroundColor)
    static var tertiaryGroupedBackground = Color(.textBackgroundColor)
    
    static var primaryFill = Color(.textBackgroundColor)
    static var secondaryFill = Color(.selectedTextBackgroundColor)
    static var tertiaryFill = Color(.selectedContentBackgroundColor)
    static var quaternaryFill = Color(.windowBackgroundColor)
    
    #endif
}
